// src/wsHandlers.js

const { handleBridgeInit } = require("./handlers/handleBridgeInit");
const { handleBridgeRead } = require("./handlers/handleBridgeRead");
const { handleBridgeWrite } = require("./handlers/handleBridgeWrite");
const { handleBridgeBrowse } = require("./handlers/handleBridgeBrowse");
const { handleBridgeSubscribe } = require("./handlers/handleBridgeSubscribe");
const { handleBridgeCall } = require("./handlers/handleBridgeCall");
const { handleBridgeDisconnect } = require("./handlers/handleBridgeDisconnect");

const logger = require("./utils/logger");

function initWebSocketHandlers(wss) {
  wss.on("connection", (ws) => {
    logger.info("Client connected via WebSocket");

    ws.on("message", async (msg) => {
		
      let data;
      try {
        data = JSON.parse(msg);
        logger.info(`Incoming WS message: ${JSON.stringify(data)}`);
      } catch (err) {
        logger.error(`Malformed WS message: ${msg}`);
        return;
      }
//console.log(data)
      const { type } = data;

      switch (type) {
        case "BRIDGE_INIT":
          await handleBridgeInit(data, ws);
          break;
        case "BRIDGE_READ":
          await handleBridgeRead(data, ws);
          break;
        case "BRIDGE_WRITE":
          await handleBridgeWrite(data, ws);
          break;
        case "BRIDGE_BROWSE":
          await handleBridgeBrowse(data, ws);
          break;
        case "BRIDGE_SUBSCRIBE":
          await handleBridgeSubscribe(data, ws);
          break;
        case "BRIDGE_CALL":
          await handleBridgeCall(data, ws);
          break;
        case "BRIDGE_DISCONNECT":
          await handleBridgeDisconnect(data, ws);
          break;
        default:
          logger.warn(`Unhandled WS message type: ${type}`);
      }
    });

    ws.on("close", () => logger.info("WebSocket connection closed"));
    ws.on("error", (err) => logger.error(`WebSocket error: ${err.message}`));
  });
}

module.exports = initWebSocketHandlers;
