const clients = require("../clients");
const sendTriggers = require("../../utils/sendTriggers");
const logger = require("../../utils/logger");
const { AttributeIds, DataType, WriteValue, StatusCodes } = require("node-opcua");

module.exports = async function opcuaWrite(message, ws) {
  const { name, writes, trigger, entity } = message;
  const client = clients[name];

  try {
    const session = client.session;
    const map = client.map || {};
    const results = {};
    const nodesToWrite = [];
    const variableNames = [];

    for (let [varName, value] of Object.entries(writes || {})) {
      const entry = map[varName];

      if (!entry || !entry.nodeId) {
        results[varName] = "Error: Variable not found in map";
        continue;
      }

      const nodeId = entry.nodeId;
      const dataTypeStr = entry.dataType;
      const opcDataType = DataType[dataTypeStr];

      if (opcDataType === undefined) {
        results[varName] = `Error: Unknown data type '${dataTypeStr}'`;
        continue;
      }

	  if (opcDataType === DataType.Boolean && typeof value === "number") {
			value = !!value; // ← convierte 0/1 en false/true
		}

		
		
	  if (opcDataType === DataType.String) {
            const isObject = typeof value === 'object' && value !== null;
            const isArray = Array.isArray(value);

            if (isObject || isArray) {
                try {
                    // Forzamos la conversión de JSON (objeto/array) a String
                    value = JSON.stringify(value);
                    console.log(`[OPCUA-WRITE] Serialized JS object for ${varName} to string: ${value}`);
                } catch (e) {
                    results[varName] = `Error: Failed to serialize object to JSON string: ${e.message}`;
                    continue;
                }
            }
        }		
		
		
		
      nodesToWrite.push(new WriteValue({
        nodeId,
        attributeId: AttributeIds.Value,
        value: { value: { dataType: opcDataType, value } }
      }));

      variableNames.push(varName);
    }

    if (nodesToWrite.length === 0) {
      return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, {
        error: "No valid variables to write",
        result: results
      });
    }

    const statusCodes = await session.write(nodesToWrite);

    let successCount = 0;
    statusCodes.forEach((code, idx) => {
      const varName = variableNames[idx];
      const ok = code === StatusCodes.Good;
      results[varName] = ok ? "OK" : `Error: ${code.toString()}`;
      if (ok) successCount++;
    });
/*
    if (successCount === 0) {
      return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, {
        error: "All writes failed",
        result: results
      });
    }
	  */
   // if(trigger!="")
    return sendTriggers(ws, "BRIDGE_WRITE_RESULT", trigger, entity, { log: "", map: results });
//	 else return;
	  
  } catch (err) {
    const error = `Write error: ${err.message}`;
    logger.error("Error " + error);
    return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, { error });
  }
};
