const logger = require("../../utils/logger");
const sendTriggers = require("../../utils/sendTriggers");
const clients = require("../clients");

async function opcuaDisconnect(message, ws) {
  const { name } = message;
  const client = clients[name];

  if (!client) {
    logger.warn(`Client '${name}' not found`);
    return sendTriggers(ws, "BRIDGE_DISCONNECTED", "", -1, {
      log: `Client '${name}' not found`,
      map: {},
    });
  }

  try {
    // Cerrar subscripciones
    if (client.subscriptions?.length) {
      for (const sub of client.subscriptions) {
        try {
          await sub.subscription?.terminate?.();
        } catch (e) {
          logger.warn(`Error terminating subscription to '${sub.variableName}': ${e.message}`);
        }
      }
    }

    // Cerrar sesión OPC-UA
    if (client.session) {
      await client.session.close();
    }

    // Desconectar cliente
    if (client.client) {
      await client.client.disconnect();
    }

    logger.info(`OPC-UA client '${name}' disconnected`);

    return sendTriggers(ws, "BRIDGE_DISCONNECTED", "", -1, {
      log: "",
      map: {},
    });

  } catch (e) {
    const error = `Disconnection failed for '${name}': ${e.message}`;
    logger.error(error);

    return sendTriggers(ws, "BRIDGE_ERROR", "", -1, {
      error,
    });
  }
}

module.exports = opcuaDisconnect;
