// src/services/mqtt/mqttRead.js

const clients = require("../clients");
const sendTriggers = require("../../utils/sendTriggers");
const logger = require("../../utils/logger");

module.exports = async function mqttRead(message, ws) {
  const { name, variables, trigger, entity } = message;
  const client = clients[name];

  if (!client || !client.lastValues) {
    const error = `MQTT client '${name}' not connected or no data received yet`;
    logger.error(`[MQTT:${name}] ${error}`);
    return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, { error });
  }

  const varNames = Array.isArray(variables)
    ? variables
    : Object.keys(variables || {});

  const result = {};
  const missing = [];

  for (const varName of varNames) {
    if (client.lastValues[varName] !== undefined) {
      result[varName] = client.lastValues[varName];
    } else {
      missing.push(varName);
    }
  }

  if (missing.length > 0) {
    logger.warn(`[MQTT:${name}] Missing values for: ${missing.join(", ")}`);
  }

  return sendTriggers(ws, "BRIDGE_READ_RESULT", trigger, entity, {
    map: result,
    log: missing.length
      ? `Some variables not available: ${missing.join(", ")}`
      : ""
  });
};
