const logger = require("../../utils/logger");
const sendTriggers = require("../../utils/sendTriggers");
const clients = require("../clients");

async function mqttDisconnect(message, ws) {
  const { name } = message;
  const client = clients[name];

  if (!client) {
    logger.warn(`[MQTT:${name}] Client not found`);
    return sendTriggers(ws, "BRIDGE_DISCONNECTED", "", -1, {
      log: `Client '${name}' not found`,
      map: {},
    });
  }

  try {
    // Desconectar del broker MQTT
    if (client.mqttClient?.connected) {
      client.mqttClient.end(true, () => {
        logger.info(`[MQTT:${name}] Disconnected from broker`);
      });
    }

    // Eliminar listener global (por seguridad)
    client.mqttClient?.removeAllListeners?.("message");

    // Eliminar del registro de clientes
    delete clients[name];

    return sendTriggers(ws, "BRIDGE_DISCONNECTED", "", -1, {
      log: `MQTT bridge '${name}' disconnected`,
      map: {},
    });

  } catch (err) {
    const error = `MQTT disconnect failed for '${name}': ${err.message}`;
    logger.error(`[MQTT:${name}] ${error}`);

    return sendTriggers(ws, "BRIDGE_ERROR", "", -1, {
      error,
    });
  }
}

module.exports = mqttDisconnect;
