// src/mqtt/mqttEmbedded.js

const aedes = require('aedes')();
const net = require('net');
const logger = require("../utils/logger");

const MQTT_PORT = 1883;

// The logic for saving and sending retained messages is managed internally by Aedes.
// We don't need a custom "announces" object.

function startEmbeddedBroker() {
  const server = net.createServer(aedes.handle);

  server.listen(MQTT_PORT, () => {
    // OLD: logger.info(`[MQTT_EMBEDDED] Broker embebido escuchando en puerto ${MQTT_PORT}`);
    logger.info(`[MQTT_EMBEDDED] Embedded broker listening on port ${MQTT_PORT}`);
  });

  // Event: new client connected
  aedes.on('client', (client) => {
    // OLD: logger.info(`[MQTT_EMBEDDED] Cliente conectado: ${client ? client.id : "?"}`);
    logger.info(`[MQTT_EMBEDDED] Client connected: ${client ? client.id : "?"}`);
  });

  // Event: client disconnected
  aedes.on('clientDisconnect', (client) => {
    // OLD: logger.info(`[MQTT_EMBEDDED] Cliente desconectado: ${client ? client.id : "?"}`);
    logger.info(`[MQTT_EMBEDDED] Client disconnected: ${client ? client.id : "?"}`);
  });

  // Event: message published
  aedes.on('publish', (packet, client) => {
    const topic = packet.topic;
    const payloadStr = packet.payload.toString();

    // Now showing all messages that come from a client,
    // including those with the 'retain' flag enabled.
    if (client) {
      // OLD: logger.info(`[MQTT_EMBEDDED] ${client.id} publicó en '${topic}': ${payloadStr}`);
      logger.info(`[MQTT_EMBEDDED] ${client.id} published to '${topic}': ${payloadStr}`);
    }

    // Aedes will automatically handle the saving of retained messages.
    // If the ESP client publishes with the 'retain' flag set to true, Aedes saves it.
    // When a new client subscribes to that topic, Aedes will send the saved message.
  });

  return {
    broker: aedes,
    // We remove getAnnounces because we no longer need it. Aedes takes care of this.
  };
}

module.exports = startEmbeddedBroker;