const clients = require("../services/clients");
const logger = require("../utils/logger");

const opcuaWrite = require("../services/opcua/opcuaWrite");
const mqttWrite = require("../services/mqtt/mqttWrite");

async function handleBridgeWrite(message, ws) {
  const { name } = message;
  const client = clients[name];

  if (!client) {
    const error = `Client '${name}' not connected`;
    logger.error(`Error ${error}`);
    return require("../utils/sendTriggers")(ws, "BRIDGE_ERROR", message.trigger, message.entity, { error });
  }

  switch (client.type) {
    case "OPCUA":
      return await opcuaWrite(message, ws);
    case "MQTT":
      return await mqttWrite(message, ws);
    default:
      const error = `Unsupported client type '${client.type}'`;
      logger.error("Error " + error);
      return require("../utils/sendTriggers")(ws, "BRIDGE_ERROR", message.trigger, message.entity, { error });
  }
}

module.exports = { handleBridgeWrite };
