const clients = require("../services/clients");
const logger = require("../utils/logger");
const sendTriggers = require("../utils/sendTriggers");

const opcuaSubscribe = require("../services/opcua/opcuaSubscribe");
const mqttSubscribe = require("../services/mqtt/mqttSubscribe");

function handleBridgeSubscribe(message, ws) {
  const { name, trigger, entity } = message;
  const client = clients[name];

  if (!client) {
    const error = `Client '${name}' not connected`;
    logger.error("Error " + error);
    return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, { error });
  }

  switch (client.type) {
    case "OPCUA":
      return opcuaSubscribe(message, ws);
    case "MQTT":
      return mqttSubscribe(message, ws);
    default:
      const error = `Subscription not supported for type '${client.type}'`;
      logger.error("Error " + error);
      return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, { error });
  }
}

module.exports = { handleBridgeSubscribe };
