const clients = require("../services/clients");
const logger = require("../utils/logger");
const sendTriggers = require("../utils/sendTriggers");

const opcuaRead = require("../services/opcua/opcuaRead");
const mqttRead = require("../services/mqtt/mqttRead");

async function handleBridgeRead(message, ws) {
  const { name, trigger, entity } = message;
  const client = clients[name];

  if (!client) {
    const error = `Client '${name}' not connected`;
    logger.error(error);
    return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, { error });
  }

  switch (client.type) {
    case "OPCUA":
      return await opcuaRead(message, ws);
    case "MQTT":
      return await mqttRead(message, ws);
    default:
      const error = `Unsupported client type '${client.type}'`;
      logger.error(error);
      return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, { error });
  }
}

module.exports = { handleBridgeRead };
