const clients = require("../services/clients");
const logger = require("../utils/logger");

const opcuaDisconnect = require("../services/opcua/opcuaDisconnect");
const mqttDisconnect = require("../services/mqtt/mqttDisconnect");

async function handleBridgeDisconnect(message, ws) {
  const { name } = message;
  const client = clients[name];

  if (!client) {
    logger.warn(`Attempted to disconnect unknown client '${name}'`);
    return;
  }

  try {
    switch (client.type) {
      case "OPCUA":
        await opcuaDisconnect(message, ws);
        break;
      case "MQTT":
        await mqttDisconnect(message, ws);
        break;
      default:
        logger.warn(`Unknown client type '${client.type}' during disconnect`);
    }
  } catch (err) {
    logger.warn(`Disconnection error for '${name}': ${err.message}`);
  }

  delete clients[name];
  logger.info(`Client '${name}' disconnected`);
}

module.exports = { handleBridgeDisconnect };
