// src/handlers/handleBridgeCall.js
const clients = require("../services/clients");
const logger = require("../utils/logger");
const sendTriggers = require("../utils/sendTriggers");

const opcuaCall = require("../services/opcua/opcuaCall");

async function handleBridgeCall(message, ws) {
  const { name, trigger, entity } = message;
  const client = clients[name];

  logger.info(`[BRIDGE_CALL] Incoming request for client '${name}'`);

  if (!client) {
    const error = `Client '${name}' not connected`;
    logger.error(error);
    return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, { error });
  }

  switch (client.type) {
    case "OPCUA":
      return await opcuaCall(message, ws);

    default:
      const error = `Unsupported client type '${client.type}'`;
      logger.error(error);
      return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, { error });
  }
}

module.exports = { handleBridgeCall };
