const clients = require("../services/clients");
const sendTriggers = require("../utils/sendTriggers");
const logger = require("../utils/logger");

const opcuaBrowse = require("../services/opcua/opcuaBrowse");
const mqttBrowse = require("../services/mqtt/mqttBrowse");

async function handleBridgeBrowse(message, ws) {
  const { name, trigger, entity } = message;
  const client = clients[name];

  if (!client) {
    const error = `Browse error: Client '${name}' not found`;
    logger.error(error);
    return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, { error });
  }

  switch (client.type) {
    case "OPCUA":
      return await opcuaBrowse(message, ws);
    case "MQTT":
      return await mqttBrowse(message, ws);
    default:
      const error = `Unsupported client type: ${client.type}`;
      logger.error(error);
      return sendTriggers(ws, "BRIDGE_ERROR", trigger, entity, { error });
  }
}

module.exports = { handleBridgeBrowse };
