// middleware.js

// AUTO-GENERATED CORE — do not modify directly.
// Edit config.js instead.


const express = require("express");
const https = require("https"); 
const WebSocket = require("ws");
const cors = require("cors");
const path = require("path");
const fs = require("fs"); 

const config = require("./config"); 

// Custom modules
const initWebSocketHandlers = require("./src/wsHandlers");
const startEmbeddedBroker = require("./src/mqtt_embedded/mqttEmbedded"); 
const logger = require("./src/utils/logger");

const app = express();

// Middleware
app.use(cors());
app.use(express.json());
app.use(express.static(path.join(__dirname, "public")));


const certOptions = {
    cert: fs.readFileSync(config.SSL.cert),
    key: fs.readFileSync(config.SSL.key)
};

const server = https.createServer(certOptions, app); 

// WebSocket setup (esto sigue igual)
const wss = new WebSocket.Server({ server });
initWebSocketHandlers(wss);


startEmbeddedBroker();


// Start server

server.listen(config.PORT, config.SERVER_HOST, () => {
  logger.info(`Server listening on https://${config.SERVER_HOST}:${config.PORT}`);
});

// ================== DIAGNOTIC ==================
server.on('listening', () => {
  const addr = server.address();
  console.log(`[DEBUG] HTTPS listening on ${addr.address}:${addr.port}`);
});

server.on('error', err => {
  console.error('[ERROR] HTTPS server error:', err);
});

server.on('tlsClientError', (err, socket) => {
  console.error('[ERROR] TLS handshake failed:', err.message);
});
// =================================================


