const { Variant, StatusCodes, AccessLevelFlag, DataType } = require("node-opcua");

function expose_rw(variable, getCallback, setCallback) {
    console.log(`[+] RW: ${variable.browseName.toString()}`);

    variable.accessLevel = AccessLevelFlag.CurrentRead | AccessLevelFlag.CurrentWrite;
    variable.userAccessLevel = AccessLevelFlag.CurrentRead | AccessLevelFlag.CurrentWrite;

    variable.bindVariable({
        get: () => new Variant({ dataType:variable.dataType.value, value: getCallback() }),
        set: (variant) => {
           // console.log(`>> Escritura en ${variable.browseName.toString()}: ${variant.value}`);
            setCallback(variant.value);
            return StatusCodes.Good;
        }
    }, true);
}

module.exports = expose_rw;
