const { Variant, makeAccessLevelFlag, DataType } = require("node-opcua");

module.exports = function expose_ro(variable, getCallback) {
    const name = variable.browseName?.toString();
    console.log(`[-] RO: ${name}`);

    variable.accessLevel = makeAccessLevelFlag("CurrentRead");
    variable.userAccessLevel = makeAccessLevelFlag("CurrentRead");

    variable.bindVariable({
        get: () => new Variant({
            dataType:variable.dataType.value,
            value: getCallback()
        })
    }, true);
};
