const { DataType } = require("node-opcua");
const expose_ro = require("../utils/expose_ro");

let isPowered = true;

function register(namespace) {
    const powerNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "System_PowerStatus_IsPowered",
        dataType: DataType.Boolean
    });

    expose_ro(powerNode);
}

function update() {
    // Simula posibles cortes de energía
    isPowered = Math.random() > 0.05; // 95% de tiempo encendido
}

module.exports = { register, update };
