const { DataType } = require("node-opcua");
const expose_ro = require("../utils/expose_ro");

let vibrationLevel = 0.0;

function register(namespace) {
    const vibrationNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "Sensor_Vibration_VibrationLevel",
        dataType: DataType.Double
    });

    expose_ro(vibrationNode);
}

function update() {
    // Simula un nivel de vibración entre 0.0 y 1.0
    vibrationLevel = parseFloat((Math.random()).toFixed(2));
}

module.exports = { register, update };
