const { DataType } = require("node-opcua");
const expose_rw = require("../utils/expose_rw");
const expose_ro = require("../utils/expose_ro");


let currentTemperature = 20.0;
let setpoint = 50.0;
let pidOutput = 0.0;

function register(namespace) {
    const tempNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "PIDControl_CurrentTemperature",
        dataType: DataType.Double
    });
    expose_ro(tempNode, () => currentTemperature);

    const setpointNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "PIDControl_Setpoint",
        dataType: DataType.Double
    });
    expose_rw(setpointNode, () => setpoint, val => setpoint = val);

    const outputNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "PIDControl_PIDOutput",
        dataType: DataType.Double
    });
    expose_ro(outputNode, () => pidOutput);
}

function update() {
    const error = setpoint - currentTemperature;
    pidOutput = error * 0.5;
    currentTemperature += pidOutput * 0.1 - 0.05;
}

module.exports = { register, update };
