const { DataType } = require("node-opcua");
const expose_ro = require("../utils/expose_ro");

let distance = 50.0;

function register(namespace) {
    const proximityNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "Sensor_Proximity_DistanceInCm",
        dataType: DataType.Double
    });

    expose_ro(proximityNode);
}

function update() {
    // Simula distancia entre 10 y 100 cm con variación aleatoria
    const delta = (Math.random() - 0.5) * 10;
    distance = Math.max(10, Math.min(100, distance + delta));
    distance = Math.round(distance);
}

module.exports = { register, update };
