const { DataType } = require("node-opcua");
const expose_ro = require("../utils/expose_ro");
const expose_rw = require("../utils/expose_rw");

let isExtended = false;
let triggerValue = false;
let inTransition = false;

// Referencia al nodo para poder actualizarlo con setValueFromSource
let stateNode = null;

function register(namespace) {
    // Nodo de estado del pistón (lectura)
    stateNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "Device_Piston_IsExtended",
        dataType: DataType.Boolean
    });
    expose_ro(stateNode, () => isExtended);

    // Nodo de trigger (escritura)
    const triggerNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "Device_Piston_Trigger",
        dataType: DataType.Boolean
    });

    expose_rw(
        triggerNode,
        () => triggerValue,
        (val) => {
            val = Boolean(val); // Forzamos booleano

            // Solo en flanco de subida y si no está en transición
            if (val && !inTransition) {
                inTransition = true;
                triggerValue = true;

                // Simulamos retardo de extensión
                setTimeout(() => {
                    isExtended = true;
                    // Notificamos nuevo estado al nodo
                    stateNode.setValueFromSource({
                        dataType: DataType.Boolean,
                        value: true
                    });

                    // Simulamos permanencia extendido y luego retraído
                    setTimeout(() => {
                        isExtended = false;
                        triggerValue = false;
                        inTransition = false;

                        // Notificamos que ha vuelto a reposo
                        stateNode.setValueFromSource({
                            dataType: DataType.Boolean,
                            value: false
                        });
                    }, 500); // Tiempo extendido

                }, 300); // Tiempo para extender
            }
        }
    );
}

function update() {
    // No se requiere lógica periódica
}

module.exports = { register, update };
