const { Variant, DataType } = require("node-opcua");
const expose_ro = require("../utils/expose_ro");

let motionValue = false;

function register(namespace) {
    const motionNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "Sensor_Motion_Detected",
        dataType: DataType.Boolean
    });

    expose_ro(motionNode, () => motionValue, DataType.Boolean);
}

function update() {
    motionValue = Math.random() > 0.7;
}

module.exports = { register, update };
