const { DataType } = require("node-opcua");
const expose_ro = require("../utils/expose_ro");

let luxLevel = 300.0;

function register(namespace) {
    const lightNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "Sensor_Light_LuxLevel",
        dataType: DataType.Double
    });

    expose_ro(lightNode);
}

function update() {
    // Simula cambios de luz: entre 100 y 1000 lux
    const delta = (Math.random() - 0.5) * 50;
    luxLevel = Math.max(100, Math.min(1000, luxLevel + delta));
    luxLevel = Math.round(luxLevel);
}

module.exports = { register, update };
