const { DataType } = require("node-opcua");
const expose_ro = require("../utils/expose_ro");

let humidityPercentage = 40.0;

function register(namespace) {
    const humidityNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "Sensor_Humidity_HumidityPercentage",
        dataType: DataType.Double
    });

    expose_ro(humidityNode);
}

function update() {
    // Simulación básica de humedad ambiente con pequeñas fluctuaciones
    const delta = (Math.random() - 0.5) * 2;
    humidityPercentage = Math.max(0, Math.min(100, humidityPercentage + delta));
    humidityPercentage = Math.round(humidityPercentage * 10) / 10;
}

module.exports = { register, update };
