const { DataType } = require("node-opcua");
const expose_ro = require("../utils/expose_ro");

let gasDetected = false;

function register(namespace) {
    const gasNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "Sensor_GasLeak_GasDetected",
        nodeId: "s=Sensor_GasLeak_GasDetected",
        dataType: DataType.Boolean
    });

    expose_ro(gasNode);
}

function update() {
    // Simulación: 5% de posibilidad de detectar gas en cada ciclo
    gasDetected = Math.random() < 0.05;
}

module.exports = { register, update };
