const { Variant, DataType } = require("node-opcua");
const expose_ro = require("../utils/expose_ro");

let doorValue = false;

function register(namespace) {
    const variable = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "Sensor_Door_IsOpen",
        dataType: DataType.Boolean, 
		minimumSamplingInterval: 1000
    });

    expose_ro(variable, () => doorValue);
}

function update() {
    doorValue = Math.random() > 0.3; 
}

module.exports = { register, update };
