const { DataType } = require("node-opcua");
const expose_ro = require("../utils/expose_ro");

let batteryLevel = 100.0;

function register(namespace) {
    const batteryNode = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "System_Battery_BatteryLevel",
        dataType: DataType.Double
    });

    expose_ro(batteryNode, () => batteryLevel);
}

function update() {
    batteryLevel = Math.max(0, batteryLevel - (Math.random() * 0.4 + 0.1));
    batteryLevel = Math.round(batteryLevel * 100) / 100;
}

module.exports = { register, update };
