const { DataType } = require("node-opcua");
const expose_rw = require("../utils/expose_rw");

let motorState = false;

function register(namespace) {
    const variable = namespace.addVariable({
        organizedBy: namespace.addressSpace.rootFolder.objects,
        browseName: "Device_Motor_Enabled",
        dataType: DataType.Boolean
    });

    expose_rw(variable, () => motorState, (val) => motorState = val);
}

function update() {
    // No cambia solo, es controlado externamente
}

module.exports = { register, update };
